#include <amxmodx>
#include <fakemeta>

#define PLUGIN "HPshop"
#define VERSION "1.0"
#define AUTHOR "XSik"

#define FM_MONEY_OFFSET 115

new health40[200]
new health60[200]
new health80[200]
new health100[200]
new health120[200]
new health140[200]
new health160[200]

new cost_40hp, cost_60hp, cost_80hp, cost_100hp, cost_120hp, cost_140hp, cost_160hp

public plugin_init() {
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	register_clcmd("say /hpshop", "show_menu_buy_hp")
	register_clcmd("say_team /hpshop", "show_menu_buy_hp")
	
	register_logevent("Event_Round_Start", 2, "1=Round_Start")
	
	cost_40hp = register_cvar("hs_40hp_cost", "2000")
	cost_60hp = register_cvar("hs_60hp_cost", "4000")
	cost_80hp = register_cvar("hs_80hp_cost", "6000")
	cost_100hp = register_cvar("hs_100hp_cost", "8000")
	cost_120hp = register_cvar("hs_120hp_cost", "10000")
	cost_140hp = register_cvar("hs_140hp_cost", "12000")
	cost_160hp = register_cvar("hs_160hp_cost", "14000")
}

public show_menu_buy_hp(id)
{
	new menu = menu_create("\rHealth Shop", "handle_buy_hp_menu")
	
	formatex(health40, 199, "+40 Health - $%d", get_pcvar_num(cost_40hp))
	menu_additem(menu, health40, "1")
	
	formatex(health60, 199, "+60 Health - $%d", get_pcvar_num(cost_60hp))
	menu_additem(menu, health60, "2")
	
	formatex(health80, 199, "+80 Health - $%d", get_pcvar_num(cost_80hp))
	menu_additem(menu, health80, "3")
	
	formatex(health100, 199, "+100 Health - $%d", get_pcvar_num(cost_100hp))
	menu_additem(menu, health100, "4")
	
	formatex(health120, 199, "+120 Health - $%d", get_pcvar_num(cost_120hp))
	menu_additem(menu, health120, "5")
	
	formatex(health140, 199, "+140 Health - $%d", get_pcvar_num(cost_140hp))
	menu_additem(menu, health140, "6")
	
	formatex(health160, 199, "+160 Health - $%d", get_pcvar_num(cost_160hp))
	menu_additem(menu, health160, "7")
	
	menu_setprop(menu, MPROP_EXIT, MEXIT_ALL)
	menu_display(id, menu, 0)
}

public handle_buy_hp_menu(id, menu, item)
{
	if (item == MENU_EXIT)
	{
		menu_destroy(menu)
		return PLUGIN_HANDLED
	}
	
	new Data[6];
	new Access;
	new Callback;
	new Name[64];
	menu_item_getinfo(menu, item, Access, Data, 5, Name, 63, Callback)
	
	new Key = str_to_num(Data);
	
	switch (Key)
	{
		case 1:
		{
			if (!is_user_alive(id))
			{
				client_print(id, print_chat, "You Have To Be Alive To Buy Health")
				return PLUGIN_HANDLED
			}
			
			new Money = fm_get_user_money(id)
			new Pcvar = get_pcvar_num(cost_40hp)
			new Health = get_user_health(id)
			
			if (Money < Pcvar)
			{
				client_print(id, print_chat, "You don't have enough money to buy this")
			}
			else
			{
				client_print(id, print_chat, "You just purchared +40 HP")
				fm_set_user_money(id, Money-Pcvar)
				fm_set_user_health (id, Health+40)
			}
		}
		
		case 2:
		{
			if (!is_user_alive(id))
			{
				client_print(id, print_chat, "You Have To Be Alive To Buy Health")
				return PLUGIN_HANDLED
			}
			
			new Money = fm_get_user_money(id)
			new Pcvar = get_pcvar_num(cost_60hp)
			new Health = get_user_health(id)
			
			if (Money < Pcvar)
			{
				client_print(id, print_chat, "You don't have enough money to buy this")
			}
			else
			{
				client_print(id, print_chat, "You just purchared +60 HP")
				fm_set_user_money(id, Money-Pcvar)
				fm_set_user_health (id, Health+60)
			}
		}
		
		case 3:
		{
			if (!is_user_alive(id))
			{
				client_print(id, print_chat, "You Have To Be Alive To Buy Health")
				return PLUGIN_HANDLED
			}
			
			new Money = fm_get_user_money(id)
			new Pcvar = get_pcvar_num(cost_80hp)
			new Health = get_user_health(id)
			
			if (Money < Pcvar)
			{
				client_print(id, print_chat, "You don't have enough money to buy this")
			}
			else
			{
				client_print(id, print_chat, "You just purchared +80 HP")
				fm_set_user_money(id, Money-Pcvar)
				fm_set_user_health (id, Health+80)
			}
		}
		
		case 4:
		{
			if (!is_user_alive(id))
			{
				client_print(id, print_chat, "You Have To Be Alive To Buy Health")
				return PLUGIN_HANDLED
			}
			
			new Money = fm_get_user_money(id)
			new Pcvar = get_pcvar_num(cost_100hp)
			new Health = get_user_health(id)
			
			if (Money < Pcvar)
			{
				client_print(id, print_chat, "You don't have enough money to buy this")
			}
			else
			{
				client_print(id, print_chat, "You just purchared +100 HP")
				fm_set_user_money(id, Money-Pcvar)
				fm_set_user_health (id, Health+100)
			}
		}
		
		case 5:
		{
			if (!is_user_alive(id))
			{
				client_print(id, print_chat, "You Have To Be Alive To Buy Health")
				return PLUGIN_HANDLED
			}
			
			new Money = fm_get_user_money(id)
			new Pcvar = get_pcvar_num(cost_120hp)
			new Health = get_user_health(id)
			
			if (Money < Pcvar)
			{
				client_print(id, print_chat, "You don't have enough money to buy this")
			}
			else
			{
				client_print(id, print_chat, "You just purchared +120 HP")
				fm_set_user_money(id, Money-Pcvar)
				fm_set_user_health (id, Health+120)
			}
		}
		
		case 6:
		{
			if (!is_user_alive(id))
			{
				client_print(id, print_chat, "You Have To Be Alive To Buy Health")
				return PLUGIN_HANDLED
			}
			
			new Money = fm_get_user_money(id)
			new Pcvar = get_pcvar_num(cost_140hp)
			new Health = get_user_health(id)
			
			if (Money < Pcvar)
			{
				client_print(id, print_chat, "You don't have enough money to buy this")
			}
			else
			{
				client_print(id, print_chat, "You just purchared +140 HP")
				fm_set_user_money(id, Money-Pcvar)
				fm_set_user_health (id, Health+140)
			}
		}
		
		case 7:
		{
			if (!is_user_alive(id))
			{
				client_print(id, print_chat, "You Have To Be Alive To Buy Health")
				return PLUGIN_HANDLED
			}
			
			new Money = fm_get_user_money(id)
			new Pcvar = get_pcvar_num(cost_160hp)
			new Health = get_user_health(id)
			
			if (Money < Pcvar)
			{
				client_print(id, print_chat, "You don't have enough money to buy this")
			}
			else
			{
				client_print(id, print_chat, "You just purchared +160 HP")
				fm_set_user_money(id, Money-Pcvar)
				fm_set_user_health (id, Health+160)
			}
		}
	}
	menu_destroy(menu)
	return PLUGIN_HANDLED
}

public Event_Round_Start()
{
	client_print(0, print_chat, "To Open Up Health Shop, Type /hpshop in chat")
}

stock fm_set_user_health(index, health) 
{
	health > 0 ? set_pev(index, pev_health, float(health)) : dllfunc(DLLFunc_ClientKill, index)
	return 1
}

stock fm_get_user_money(index) 
{
	return get_pdata_int(index, FM_MONEY_OFFSET)
}

stock fm_set_user_money(index, money, flash = 1) 
{
	set_pdata_int(index, FM_MONEY_OFFSET, money);
	
	message_begin(MSG_ONE, get_user_msgid("Money"), _, index);
	write_long(money);
	write_byte(flash ? 1 : 0);
	message_end();
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1053\\ f0\\ fs16 \n\\ par }
*/
